export default defineEventHandler(async (event) => {
  const config = useRuntimeConfig()
  const uid = getRouterParam(event, 'uid')

  // Redirect to Laravel OAuth authorize endpoint
  // Laravel will handle authentication and redirect to eBay
  const laravelUrl = config.api.laravel
  const redirectUrl = `${laravelUrl}/oauth/ebay/authorize/${uid}`

  return sendRedirect(event, redirectUrl, 302)
})
